<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Search Student Books</title>
    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f5f5f5; /* Light gray background */
            color: #333; /* Dark text color */
            margin: 0;
            padding: 0;
            line-height: 1.6;
            animation: fadeIn 1.5s ease-out;
        }

        .navbar {
            display: flex;
            justify-content: center;
            align-items: center;
            background-color: gray; /* Dark gray background */
            padding: 15px 30px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            border-bottom: 2px solid #004d40; /* Darker blue bottom border */
            position: relative;
            z-index: 1000;
        }

        .navbar .nav-links {
            display: flex;
            gap: 25px;
        }

        .navbar .nav-links a {
            text-decoration: none;
            font-size: 20px; /* Larger font size */
            font-weight: 600; /* Slightly bolder font weight */
            color: white; /* White text color */
            display: flex;
            align-items: center;
            transition: color 0.3s ease, transform 0.3s ease;
        }

        .navbar .nav-links a i {
            margin-right: 10px;
            font-size: 24px; /* Larger icon size */
        }

        .navbar .nav-links a:hover {
            transform: scale(1.05);
            color: #e0e0e0; /* Slightly lighter white on hover */
        }

        h1 {
            font-size: 36px; /* Larger font size */
            color: #1e88e5; /* Light blue for heading */
            margin: 30px 0;
            text-align: center;
            animation: fadeIn 2s ease-out;
        }

        form {
            margin: 0 auto;
            padding: 20px;
            background-color: #ffffff; /* White background */
            border-radius: 10px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.2);
            width: 90%;
            max-width: 700px;
            transition: box-shadow 0.3s ease;
            animation: fadeInUp 1s ease-out;
        }

        form:hover {
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.3);
        }

        label {
            font-size: 20px; /* Larger font size */
            margin-right: 10px;
            font-weight: 600;
            display: block;
            margin-bottom: 10px;
        }

        input[type="text"], select {
            padding: 14px;
            font-size: 18px; /* Larger font size */
            border: 1px solid #ccc;
            border-radius: 6px;
            width: calc(100% - 180px);
            box-sizing: border-box;
            transition: border-color 0.3s ease;
        }

        input[type="text"]:focus, select:focus {
            border-color: #0288d1; /* Darker blue focus border */
            outline: none;
        }

        button {
            padding: 14px 22px;
            font-size: 18px; /* Larger font size */
            color: #ffffff;
            background-color: #0288d1; /* Darker blue */
            border: none;
            border-radius: 6px;
            cursor: pointer;
            margin-left: 10px;
            transition: background-color 0.3s ease, transform 0.3s ease;
        }

        button:hover {
            background-color: #01579b; /* Darker blue on hover */
            transform: translateY(-2px);
        }

        table {
            width: 90%;
            margin: 30px auto;
            border-collapse: collapse;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.2);
            background-color: #ffffff; /* White background */
            transition: box-shadow 0.3s ease;
            animation: fadeInUp 1s ease-out;
        }

        table:hover {
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.3);
        }

        table, th, td {
            border: 1px solid #ddd;
        }

        th, td {
            padding: 14px;
            text-align: left;
            font-size: 18px; /* Larger font size */
        }

        th {
            background-color: #0288d1; /* Darker blue */
            color: #ffffff;
            font-weight: 700;
        }

        tr:nth-child(even) {
            background-color: #f2f2f2; /* Light gray for even rows */
        }

        .print-btn {
            display: block;
            margin: 20px auto;
            padding: 14px 26px;
            font-size: 18px; /* Larger font size */
            color: #ffffff;
            background-color: #0288d1; /* Darker blue */
            border: none;
            border-radius: 6px;
            cursor: pointer;
            transition: background-color 0.3s ease, transform 0.3s ease;
        }

        .print-btn:hover {
            background-color: #01579b; /* Even darker blue on hover */
            transform: scale(1.05);
        }

        @media print {
            .navbar, form, .print-btn {
                display: none;
            }
            table {
                width: 100%;
            }
        }

        /* Animations */
        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(-20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
    </style>
    <script>
        function printReport() {
            window.print();
        }

        // Function to update the clock every second
        function updateClock() {
            const now = new Date();
            const hours = now.getHours().toString().padStart(2, '0');
            const minutes = now.getMinutes().toString().padStart(2, '0');
            const seconds = now.getSeconds().toString().padStart(2, '0');
            document.getElementById('clock').textContent = `${hours}:${minutes}:${seconds}`;
        }

        // Initialize the clock
        setInterval(updateClock, 1000);
        document.addEventListener('DOMContentLoaded', updateClock);
    </script>
</head>
<body>
    <div class="navbar">
        <div class="nav-links">
            <a href="give_book.php"><i class="fas fa-hand-holding"></i> Give Book</a>
            <a href="returnbook.php"><i class="fas fa-undo-alt"></i> Return Book</a>
            <a href="Insert_book.php"><i class="fas fa-book"></i> Add New Book</a>
            <a href="Insert_student.php"><i class="fas fa-user-plus"></i> Add Student</a>
            <a href="viewreport.php"><i class="fas fa-file-alt"></i> View Report</a>
        </div>
    </div>

    <h1>Search for Student Books</h1>

    <form method="get">
        <label for="admission_number">Enter Admission Number:</label>
        <input type="text" id="admission_number" name="admission_number" placeholder="Enter admission number">
        <button type="submit"><i class="fas fa-search"></i> Search</button>
        <label for="class">Select Class:</label>
        <select id="class" name="class" required>
            <?php
            include 'conn.php';
            $classSql = "SELECT DISTINCT class FROM students ORDER BY class";
            $classResult = $conn->query($classSql);
            if ($classResult->num_rows > 0) {
                while ($row = $classResult->fetch_assoc()) {
                    echo "<option value='{$row['class']}'>{$row['class']}</option>";
                }
            }
            ?>
        </select>
        <button type="submit"><i class="fas fa-search"></i> Search</button>
    </form>

    <?php
    if (isset($_GET['admission_number'])) {
        $admission_number = $_GET['admission_number'];
        $studentSql = "SELECT fullname, class FROM students WHERE admission_number = ?";
        $studentStmt = $conn->prepare($studentSql);
        $studentStmt->bind_param('s', $admission_number);
        $studentStmt->execute();
        $studentResult = $studentStmt->get_result();
        $bookSql = "SELECT b.book_no, b.book_name
                    FROM books_already_given bag
                    JOIN books b ON bag.book_no = b.book_no
                    WHERE bag.admission_number = ?";
        $bookStmt = $conn->prepare($bookSql);
        $bookStmt->bind_param('s', $admission_number);
        $bookStmt->execute();
        $bookResult = $bookStmt->get_result();

        if ($studentResult->num_rows > 0) {
            $student = $studentResult->fetch_assoc();
            echo "<h2><i class='fas fa-user'></i> Student: {$student['fullname']} ({$student['class']})</h2>";
            if ($bookResult->num_rows > 0) {
                echo "<table>
                        <tr>
                            <th>Book Number</th>
                            <th>Book Name</th>
                        </tr>";
                while ($row = $bookResult->fetch_assoc()) {
                    echo "<tr>
                            <td>{$row['book_no']}</td>
                            <td>{$row['book_name']}</td>
                          </tr>";
                }
                echo "</table>";
                echo "<button class='print-btn' onclick='printReport()'><i class='fas fa-print'></i> Print Report</button>";
            } else {
                echo "<p>No books found for this student.</p>";
            }
        } else {
            echo "<p>Student not found.</p>";
        }
        $studentStmt->close();
        $bookStmt->close();
    }

    if (isset($_GET['class'])) {
        $class = $_GET['class'];
        $classSql = "SELECT s.fullname, s.class, b.book_no, b.book_name
                     FROM students s
                     LEFT JOIN books_already_given bag ON s.admission_number = bag.admission_number
                     LEFT JOIN books b ON bag.book_no = b.book_no
                     WHERE s.class = ?";
        $classStmt = $conn->prepare($classSql);
        $classStmt->bind_param('s', $class);
        $classStmt->execute();
        $classResult = $classStmt->get_result();

        if ($classResult->num_rows > 0) {
            $currentStudent = '';
            echo "<h2><i class='fas fa-users'></i> Books Assigned to Students in Class: $class</h2>";
            echo "<table>
                    <tr>
                        <th>Student Name</th>
                        <th>Class</th>
                        <th>Book Number</th>
                        <th>Book Name</th>
                    </tr>";
            while ($row = $classResult->fetch_assoc()) {
                if ($currentStudent !== $row['fullname']) {
                    if ($currentStudent !== '') {
                        echo "<tr><td colspan='4'>&nbsp;</td></tr>";
                    }
                    echo "<tr>
                            <td colspan='4'><strong>{$row['fullname']} ({$row['class']})</strong></td>
                          </tr>";
                    $currentStudent = $row['fullname'];
                }
                echo "<tr>
                        <td></td>
                        <td></td>
                        <td>{$row['book_no']}</td>
                        <td>{$row['book_name']}</td>
                      </tr>";
            }
            echo "</table>";
            echo "<button class='print-btn' onclick='printReport()'><i class='fas fa-print'></i> Print Report</button>";
        } else {
            echo "<p>No students found in this class.</p>";
        }
        $classStmt->close();
    }
    $conn->close();
    ?>
</body>
</html>
